#pragma once

#include <util/system/defaults.h>
#include <util/stream/output.h>
#include <util/stream/input.h>


namespace NZonesMakeup {

    struct TPosition {
        TPosition();
        TPosition(ui16 sent, ui16 word, ui16 wordInDoc);
        bool operator < (const TPosition& right) const;
        bool operator == (const TPosition& other) const;
        bool operator != (const TPosition& other) const;
        void Serialize(IOutputStream& out) const;
        void Deserialize(IInputStream& in, int version);

        inline size_t Hash() const {
            return (static_cast<size_t>(Sent) << 32) + (static_cast<size_t>(Word) << 16) + WordInDoc;
        }

        struct THash {
            inline size_t operator()(const TPosition& ps) const {
                return ps.Hash();
            }
        };

        ui16 Sent;
        ui16 Word;
        ui32 WordInDoc;
    };

}
