#pragma once

#include "makeup_manager.h"
#include "document_makeup.h"

class TReadWriteRTYMakeupManager : public TRTYMakeupManager, public IMakeupWritableStorage, public IMakeupWritableStorageOwner {
public:// IMakeupStorage
    TMakeupAllocatorsStorage& GetAllocatorsStorage() override;

public:// IMakeupWrittableStorage
    void StoreZone(ui32 docid, NZonesMakeup::TZoneNumber, ui16 sentBegin, ui16 wordBegin, ui32 wordBeginInDoc, ui16 sentEnd, ui16 wordEnd, ui32 wordEndInDoc) override;
    void MarkDocNoZones(ui32 docId) override;
    void BuildMakeup(ui32 docId) override;
    NZonesMakeup::TZoneNumber DecodeZone(const TString& name) override;
    void AddZone(const TString& name) override;
    void AddZoneUnsafe(const TString& name) override;
    TOptionalAllocator& GetTempStorageAllocator() override;

public: // IMakeupWritableStorageOwner
    IMakeupWritableStorage* GetMakeupStorage() override;

public: // ISentenceZonesReader
    TSentenceZones GetSentZones(const ui32 docId, const ui32 sent) const override;
    ui32 GetZoneLength(const ui32 docId, const ui32 zoneNumber) const override;

public: // NRTYServer::IIndexComponentManager
    ui32 GetDocumentsCount() const override;

public:
    TReadWriteRTYMakeupManager(const TPathName& indexDir, const TRTYServerConfig& config, bool canReuseDocIds, bool useMemoryPool, bool doClean);
    TReadWriteRTYMakeupManager(ui32 docsCount, const TRTYServerConfig& config, bool canReuseDocIds, bool useMemoryPool, bool doClean);
    void AddDocument(ui32 docId, const NZonesMakeup::TDocumentMakeup& doc, bool rawCopy = false);
    void Serialize(IOutputStream& hdrOut, IOutputStream& docsOut,const TVector<ui32>* remapTable) const;
    void DeserializeDocument(ui32 docId, IInputStream& in);
    void SerializeDocument(ui32 docId, IOutputStream& out) const;
    const NZonesMakeup::TDocumentMakeup& GetDocument(int docId) const;
    void PrintPoolSizes() const;

    bool operator == (const TReadWriteRTYMakeupManager& other) const;
    bool operator != (const TReadWriteRTYMakeupManager& other) const;

protected:
    void DeserializeDocuments(IInputStream& in, ui32 version, ui32 countDocs) override;
    bool IsCorrectDocument(ui32 docid) const override;
    ui32 GetSentsCount(ui32 docid) const override;

private:
    // Very dangerous methods pair
    void Resize(ui32 docid);
    NZonesMakeup::TDocumentMakeup& MutableDocument(int docId);

    TVector<NZonesMakeup::TDocumentMakeup> Documents;
    ui32 CountDocs;
    bool CanReuseDocIds;
    ITransaction TransactionResize;
    TOptionalAllocator TempStorageAllocator;
    TMakeupAllocatorsStorage AllocatorStorage;
};
