#pragma once

#include "document_makeup.h"
#include "makeup_saver.h"
#include "makeup_storage_interface.h"
#include "zones_description.h"

#include <saas/rtyserver/config/config.h>


class TSequentialWriteMakeupStorage : public IMakeupWritableStorage, public IMakeupStorage {
public:

    TSequentialWriteMakeupStorage(const TRTYServerConfig& config);

    // IMakeupWritableStorage
    virtual void StoreZone(ui32 docid, NZonesMakeup::TZoneNumber,
        ui16 sentBegin, ui16 wordBegin, ui32 wordBeginInDoc,
        ui16 sentEnd, ui16 wordEnd, ui32 wordEndInDoc) override;

    virtual void MarkDocNoZones(ui32 docId) override;
    virtual void BuildMakeup(ui32 docId) override;
    virtual NZonesMakeup::TZoneNumber DecodeZone(const TString& name) override;
    virtual void AddZone(const TString& name) override;
    virtual void AddZoneUnsafe(const TString& name) override;
    virtual TOptionalAllocator& GetTempStorageAllocator() override;

    //IMakeupStorage
    virtual bool GetDoClean() const override;
    virtual NZonesMakeup::IZonesDescription* GetZonesDescription() override;
    virtual const NZonesMakeup::IZonesDescription* GetZonesDescription() const override;
    virtual TMakeupAllocatorsStorage& GetAllocatorsStorage() override;


    // Own methods
    void StartDocId(const ui32 docId);
    void FinishDocId(const ui32 docId);
    void SerializeZonesDescription(IOutputStream& output, const ui32 docCount);
    void SerializeCurrentDocument(IOutputStream& output);

private:
    TZonesDescription ZonesDescription;
    ui32 CurrentDocId = Max<ui32>();
    THolder<NZonesMakeup::TDocumentMakeup> CurrentDocument;
    TMakeupAllocatorsStorage AllocatorStorage;
    TOptionalAllocator TempStorageAllocator;
};

class TSequentialWriteMakeupManager : public IMakeupWritableStorageOwner,
    public TNonCopyable
{
public:

    TSequentialWriteMakeupManager(const TRTYServerConfig& config, const ui32 docsCount);
    // IMakeupWritableStorageOwner
    virtual IMakeupWritableStorage* GetMakeupStorage() override;

    //Own methods
    void StorePosition(const ui32 docId, const char* key, SUPERLONG position);
    void Serialize(IOutputStream& hdrOutput, IOutputStream& docsOutput);
    bool IsZoneForStore(const char* key) const;

private:
    TSequentialWriteMakeupStorage MakeupStorage;
    TVector<TMakeupSaver> Savers;
    bool IsPrefixed = false;
};
