#pragma once

#include "position.h"

#include <util/generic/vector.h>
#include "zones_description_interface.h"
#include <library/cpp/logger/global/global.h>

namespace NZonesMakeup {

    class TZoneSpan {
    public:
        typedef TVector<TZoneSpan> TVectorType;

        TZoneSpan(IInputStream& in, int version);
        TZoneSpan(const TPosition& begin, const TPosition& end);
        void Serialize(IOutputStream& out) const;
        void Deserialize(IInputStream& in, int version);
        const TPosition GetBegin() const;
        const TPosition GetEnd() const;
        bool operator == (const TZoneSpan& other) const;
        bool operator != (const TZoneSpan& other) const;

    private:
        TPosition Begin;
        TPosition End;
    };

    class TZoneMakeup {
    public:
        typedef TVector<TZoneMakeup> TVectorType;
        typedef ui16 TSent;
        typedef ui16 TWordInSent;

        TZoneMakeup();
        TZoneMakeup(IInputStream& in, int version);
        static void MarkSentsBySpan(NZonesMakeup::TSentsMakeup& sents, NZonesMakeup::TZoneId id, ui32 startSent, ui32 endSent);
        ui32 GetLengthInWords() const;
        ui32 GetSpansCount() const {
            return StartSent.size();
        }
        TZoneSpan GetSpan(ui32 index) const {
            VERIFY_WITH_LOG(index < StartSent.size(), "Incorrect span index");
            return TZoneSpan(TPosition(StartSent[index], StartWord[index], 0), TPosition(FinishSent[index], FinishWord[index], 0));
        }
        void AddSpan(TZoneSpan span);
        void Serialize(IOutputStream& out) const;
        void Deserialize(IInputStream& in, int version);
        bool operator == (const TZoneMakeup& other) const;
        bool operator != (const TZoneMakeup& other) const;

    private:
        TVector<TSent> StartSent;
        TVector<TSent> FinishSent;
        TVector<TWordInSent> StartWord;
        TVector<TWordInSent> FinishWord;
        ui32 LengthInWords;
    };

}
