#pragma once

#include "zone_extractor_config.h"

#include <saas/library/daemon_base/config/daemon_config.h>

#include <kernel/multipart_archive/config/config.h>

#include <library/cpp/charset/doccodes.h>
#include <library/cpp/langs/langs.h>

#include <util/generic/map.h>
#include <util/generic/maybe.h>
#include <util/generic/string.h>

namespace NOxygen {
    class TOxygenOptions;
}

struct TRTYServerConfig;

namespace NRTYServer {

    class TGroupingConfig;

    struct TCommonIndexersConfig {
        struct TNGrammZoneInfo {
            TString Name;
            ui32 NBase = 3;

            bool Parse(const TString& info);
        };

        ~TCommonIndexersConfig();

        TString HtmlParserConfigFile;
        TString XmlParserConfigFile;
        TString IndexLog;
        TMaybe<ui32> IndexLogLevel;
        TString DocProperty;
        TString RecognizeLibraryFile;
        TString OxygenOptionsFile;
        THolder<NOxygen::TOxygenOptions> OxygenOptions;
        ECharset DefaultCharset;
        ELanguage DefaultLanguage;
        ELanguage DefaultLanguage2;
        bool StoreDateAttrsMsk = false;
        const TRTYServerConfig& Owner;
        THolder<TGroupingConfig> GroupingConfig;
        bool Enabled;
        bool PauseOnStart;
        bool UseSlowUpdate;
        bool TokenizeUrl;
        bool MadeUrlAttributes;
        bool RejectDuplicates;
        bool SaveDeletedDocuments = false;
        TString ProtocolType;
        bool TimestampControlEnabled;
        TZoneExtractorConfig ZonesToProperties;
        NRTYArchive::TMultipartConfig TextArchiveParams;
        bool StoreUpdateData;
        TString NGrammZones;
        TMap<TString, TNGrammZoneInfo> NGrammZonesVector;
        bool StoreTextToArchive;
        bool UseHTML5Parser;
        TDaemonConfig::THttpOptions ServerOptions;
        ui64 DocsCountLimit = Max<ui64>();
        TMaybe<ui32> IndexDate;
        bool NoNeededFreqKeys = false;
        bool BackwardCompatibleTokenization = false;

        TCommonIndexersConfig(const TRTYServerConfig& owner);
        void Init(const TYandexConfig::Section* section);
        void Init(const TYandexConfig::Directives& directives);
        void ToString(TStringOutput& so) const;
    };

}
