#include "get_value.h"

namespace NRTYServer {
    namespace NImpl {

        template <>
        void GetValue<TString>(TString& field, const char* name, const TYandexConfig::Directives& directives) {
            field = directives.Value(name, TString());
        }
        template <>
        void GetValue<ECharset>(ECharset& field, const char* name, const TYandexConfig::Directives& directives) {
            field = CharsetByName(directives.Value(name, TString()).data());
        }
        template <>
        void GetValue<ELanguage>(ELanguage& field, const char* name, const TYandexConfig::Directives& directives) {
            field = LanguageByName(directives.Value(name, TString()).data());
        }

    }
}
