#pragma once

#include <library/cpp/langs/langs.h>
#include <library/cpp/yconf/conf.h>

namespace NRTYServer {
    namespace NImpl {

        template <class T>
        void GetValueDef(T& field, const char* name, const TYandexConfig::Directives& directives) {
            field = directives.Value(name, field);
        }

        template <class T>
        void GetValue(T& field, const char* name, const TYandexConfig::Directives& directives) {
            field = directives.Value(name, field);
        }

        template <>
        void GetValue<TString>(TString& field, const char* name, const TYandexConfig::Directives& directives);
        template <>
        void GetValue<ECharset>(ECharset& field, const char* name, const TYandexConfig::Directives& directives);
        template <>
        void GetValue<ELanguage>(ELanguage& field, const char* name, const TYandexConfig::Directives& directives);

    }
}

#define GET_VALUE(name) {NRTYServer::NImpl::GetValue(name, #name, directives);}
#define GET_VALUE_DEF(name) {NRTYServer::NImpl::GetValueDef(name, #name, directives);}
