#include "grouping_config.h"

#include <kernel/groupattrs/docsattrswriter.h>

namespace NRTYServer {

TGroupingConfig::TGroupingConfig(const TYandexConfig::Directives& directives)
    : NGroupingAttrs::TConfig(NGroupingAttrs::TConfig::Index)
{
    InitFromStringWithTypes(directives.Value("Groups", TString()));
    NGroupingAttrs::TVersion v;
    if (directives.GetValue("IndexaaVersion", v)) {
        Version = v;
    }
}

TGroupingConfig::TGroupingConfig(const TString& groups)
    : NGroupingAttrs::TConfig(NGroupingAttrs::TConfig::Index)
{
    InitFromStringWithTypes(groups);
}

bool TGroupingConfig::HasUniqueAttrs() const {
    for (ui32 i = 0; i < AttrCount(); ++i)
        if (IsAttrUnique(i))
            return true;
    return false;
}

ui32 TGroupingConfig::GetVersion() const {
    if (Version) {
        return *Version;
    }
    return HasUniqueAttrs() ? NGroupingAttrs::TDocsAttrsWriter::DefaultWritableVersion : NGroupingAttrs::TDocsAttrsWriter::DefaultVersion;
}


void TGroupingConfig::ToStringStream(TStringOutput& so) const {
    so << "Groups: " << NGroupingAttrs::TConfig::ToString() << Endl;
    if (Version) {
        so << "IndexaaVersion: " << *Version << Endl;
    }
}

}
