#pragma once

#include <library/cpp/streams/special/throttle.h>
#include <library/cpp/yconf/conf.h>

struct TRTYServerConfig;

namespace NRTYServer {

    struct TMergerConfig {
        enum TMergerCheckPolicyType {
            mcpTime            /* "TIME" */,
            mcpNewIndex        /* "NEWINDEX" */,
            mcpContinuous      /* "CONTINUOUS" */,
            mcpNewIndexSimple  /* "__NEWINDEX" */, //internal usage only
            mcpNone            /* "NONE" */
        };
        enum class ESegmentsSort {
            Size            /* "SIZE" */, // default - start with the smallest
            Id              /* "ID" */    // rty_jupi - start with the oldest
        };
        enum class EDocIdGenerator {
            Default          /* "DEFAULT" */, // default - lookup and reuse old docids, if no pruning
            Sequential       /* "SEQ" */      // sequential - always get new id
        };
        enum class ELockPolicy {
            None,
            OnStart,
            OnSwitch
        };

        struct TMaxDocsPerKps {
            TMaxDocsPerKps();
            ui64 Get(ui64 kps) const;
            void Init(const TYandexConfig::Section& section);
            TString ToString() const;
            bool Enabled() const;

        private:
            TMap<ui64, ui64> Map;
        };

        unsigned MaxSegments;
        bool Enabled;
        int Threads;
        unsigned MaxDocumentsToMerge;
        TMergerCheckPolicyType MergerCheckPolicy;
        ESegmentsSort SegmentsSort;
        EDocIdGenerator DocIdGenerator;
        unsigned TimingCheckIntervalMilliseconds;
        unsigned NewIndexDefermentSec;
        ui32 MaxDeadlineDocs;
        TThrottle::TOptions WriteOption;
        bool ClearRemoved;
        TString IndexSwitchSystemLockFile;
        ELockPolicy LockPolicy;
        TMaxDocsPerKps MaxDocsPerKps;
        TString TmpfsDir;
        ui32 MaxPrepsToUseTmpfs;

        const TRTYServerConfig& Owner;

        TMergerConfig(const TRTYServerConfig& owner);
        void Init(const TYandexConfig::Section& section);
        void Init(const TYandexConfig::Directives& directives);
        TString ToString() const;

        const TString& GetDirectory() const;
    };

}
