#include "monitor_config.h"

#include "config.h"
#include "get_value.h"

#include <library/cpp/mediator/global_notifications/system_status.h>

namespace NRTYServer {

TMonitorConfig::TMonitorConfig(const TRTYServerConfig& owner)
    : Enabled(true)
    , CheckIntervalSeconds(10)
    , LimitCheckFail(10)
    , CrashRetries(5)
    , CrashCodes() // disabled by default
    , Owner(owner)
{
}

void TMonitorConfig::Init(const TYandexConfig::Directives& directives) {
    GET_VALUE(Enabled);
    GET_VALUE(CheckIntervalSeconds);
    GET_VALUE(LimitCheckFail);
    GET_VALUE(CrashRetries);

    CrashCodes.clear();
    TVector<TString> crashCodes;
    directives.FillArray("CrashCodes", crashCodes);
    for (const TString& vl : crashCodes) {
        int code;
        TryFromStringWithDefault<int>(vl, code, 0);
        AssertCorrectConfig(code != 0, "Invalid value");
        CrashCodes.insert(code);
    }
}

TString TMonitorConfig::ToString() const {
    TString s;
    TStringOutput so(s);

    so << "<Monitoring>" << Endl;
    so << "Enabled : " << Enabled << Endl;
    so << "LimitCheckFail : " << LimitCheckFail << Endl;
    so << "CheckIntervalSeconds : " << CheckIntervalSeconds << Endl;
    so << "CrashCodes : " << JoinStrings(CrashCodes.begin(), CrashCodes.end(), ",") << Endl;
    so << "CrashRetries : " << CrashRetries << Endl;
    so << "</Monitoring>" << Endl;
    return s;
}

}
