#pragma once

#include <saas/rtyserver/model/realm/realm.h>

#include <library/cpp/yconf/conf.h>

#include <util/generic/map.h>
#include <util/generic/string.h>
#include <util/generic/vector.h>

class TFsPath;

namespace NOxygen {
    class TOxygenOptions;
}

struct TRTYServerConfig;

namespace NRTYServer {

    struct TIndexerConfigDisk;
    struct TIndexerConfigMemory;
    struct TMergerConfig;

    struct TRealmConfig {
    public:
        const TRTYServerConfig& Owner;

        TString Name;
        TString ConfigName;
        NRTYServer::ERealm Type = NRTYServer::ERealm::Persistent;
        NRTYServer::EStorageType StorageType = NRTYServer::EStorageType::Disk;
        ui32 IndexingOrder;
        ui32 SearchersCountLimit;
        TString RealmDirectory;
        bool ClearOnStart = false;

        THolder<NRTYServer::TIndexerConfigDisk> IndexerConfigDisk;
        THolder<NRTYServer::TIndexerConfigMemory> IndexerConfigMemory;

        TString OxygenOptionsFile;
        THolder<NOxygen::TOxygenOptions> OxygenOptions;

        THolder<TMergerConfig> MergerConfig;
    public:
        TRealmConfig(const TRTYServerConfig& owner);
        TRealmConfig(TRealmConfig&&) = default;
        ~TRealmConfig();
        void Init(const TString& name, const TYandexConfig::Section* section);
        void InitByDirectives(const TYandexConfig::Directives& directives);
        TString ToString() const;
        void UpdateIndexersPtr();

        const NOxygen::TOxygenOptions* GetOxygenOptions() const;

        const TIndexerConfigDisk& GetIndexerConfigDisk() const;
        const TIndexerConfigMemory& GetIndexerConfigMemory() const;
        const TMergerConfig& GetMergerConfig() const;

    public:
        static TString MakeRealmName(ui32 indexingOrder, const TString& realmName);
    };

    struct TRealmListConfig {
    public:
        const TRTYServerConfig& Owner;
        ui32 CloseThreads;
        bool AutoGenerated;
        TMap<TString, TRealmConfig> RealmsConfig;
    public:
        TRealmListConfig(const TRTYServerConfig& owner);
        void InitDefaultConfig(const TYandexConfig::Section* indexerSection, const TYandexConfig::Section* mergerSection);
        void Init(const TYandexConfig::Section* section);
        void InitByDirectives(const TYandexConfig::Directives& directives);
        void UpdateIndexersPtr();
        const TRealmConfig& GetMainRealmConfig() const;
        TVector<TString> GetRealmConfigNames() const;
        ui32 GetNumberDiskRealms() const;
        const TRealmConfig& GetRealmConfig(const TFsPath& indexDir) const;
        const TRealmConfig& GetRealmConfigByConfigName(const TString& realmConfigName) const;
        TString ToString() const;
    };

}
