#include "repair_config.h"

#include "config.h"
#include "get_value.h"

namespace NRTYServer {

TRepairConfig::TRepairConfig(const TRTYServerConfig& owner)
    : Threads(10)
    , Enabled(true)
    , NormalizerThreads(1)
    , Owner(owner)
{
}

void TRepairConfig::Init(const TYandexConfig::Directives& directives) {
    GET_VALUE(Threads);
    GET_VALUE(Enabled);
    GET_VALUE(NormalizerThreads);
}

TString TRepairConfig::ToString() const {
    TString s;
    TStringOutput so(s);

    so << "<Repair>" << Endl;
    so << "Enabled : " << Enabled << Endl;
    so << "Threads : " << Threads << Endl;
    so << "NormalizerThreads : " << NormalizerThreads << Endl;
    so << "</Repair>" << Endl;
    return s;
}

}
