#include "search_server_options.h"
#include "get_value.h"

#include <library/cpp/http/server/options.h>

namespace NRTYServer {

TSearchServerOptions::TSearchServerOptions(const TString& listen, const TString& reqs, const TString& failReqs) {
    SetThreadsName(listen, reqs, failReqs);
}

void TSearchServerOptions::Init(const TYandexConfig::Directives& directives, bool verifyThreads /*= true*/) {
    THttpOptions::Init(directives, verifyThreads);
    GET_VALUE(MainThreads);
    GET_VALUE(MainQueueSize);
    GET_VALUE(FactorThreads);
    GET_VALUE(FactorQueueSize);
    GET_VALUE(FetchThreads);
    GET_VALUE(FetchQueueSize);
    GET_VALUE(SnippetAdaptiveThreads);
    GET_VALUE(SnippetAdaptiveQueueSize);
    GET_VALUE(InfoThreads);
    GET_VALUE(InfoQueueSize);
    GET_VALUE(LongReqsThreads);
    GET_VALUE(LongReqsQueueSize);
    GET_VALUE(DbgReqsThreads);
    GET_VALUE(DbgReqsQueueSize);

    if (!MainThreads) {
        MainThreads = nThreads;
        MainQueueSize = MaxQueueSize;
    }
}

void TSearchServerOptions::ToStringImpl(TStringStream& so) const {
    THttpOptions::ToStringImpl(so);
    so << "MainThreads : " << MainThreads << Endl;
    so << "MainQueueSize : " << MainQueueSize << Endl;
    so << "FactorThreads : " << FactorThreads << Endl;
    so << "FactorQueueSize : " << FactorQueueSize << Endl;
    so << "FetchThreads : " << FetchThreads << Endl;
    so << "FetchQueueSize : " << FetchQueueSize << Endl;
    so << "SnippetAdaptiveThreads : " << SnippetAdaptiveThreads << Endl;
    so << "SnippetAdaptiveQueueSize : " << SnippetAdaptiveQueueSize << Endl;
    so << "InfoThreads : " << InfoThreads << Endl;
    so << "InfoQueueSize : " << InfoQueueSize << Endl;
    so << "LongReqsThreads : " << LongReqsThreads << Endl;
    so << "LongReqsQueueSize : " << LongReqsQueueSize << Endl;
}

}
