#pragma once

#include <saas/library/daemon_base/config/daemon_config.h>

namespace NRTYServer {

class TSearchServerOptions : public TDaemonConfig::THttpOptions {
public:
    ui32 MainThreads = 0;
    ui32 MainQueueSize = 0;
    ui32 FactorThreads = 0;
    ui32 FactorQueueSize = 0;
    ui32 FetchThreads = 0;
    ui32 FetchQueueSize = 0;
    ui32 SnippetAdaptiveThreads = 0;
    ui32 SnippetAdaptiveQueueSize = 0;
    ui32 InfoThreads = 0;
    ui32 InfoQueueSize = 0;
    ui32 LongReqsThreads = 0;
    ui32 LongReqsQueueSize = 0;
    ui32 DbgReqsThreads = 0;
    ui32 DbgReqsQueueSize = 0;

    TSearchServerOptions() = default;

    TSearchServerOptions(const TString& listen, const TString& reqs, const TString& failReqs);

    virtual void Init(const TYandexConfig::Directives& directives, bool verifyThreads = true) override;

protected:
    virtual void ToStringImpl(TStringStream& so) const override;
};

}
