#pragma once

#include <library/cpp/yconf/conf.h>

#include <util/generic/set.h>

namespace NRTYServer {

    struct TShardsConfig {
        TString ToString() const;
        void Init(const TYandexConfig::Directives& directives);
        void Init(const char* shardsNumber);
        inline size_t LocalCount() const {
            return LocalShards.size();
        }
        inline bool IsLocalShard(size_t shard) const {
            return LocalShards.count(shard);
        }
        typedef TSet<size_t> TLocalShards;
        TLocalShards LocalShards;
        size_t Number;
    private:
        void AddChunk(const TString& val);
    };

}
