#pragma once

#include <library/cpp/streams/special/throttle.h>
#include <library/cpp/yconf/conf.h>

#include <util/generic/map.h>
#include <util/generic/string.h>

namespace NRTYServer {

    struct TBallocOptions {
        ui64 SoftLimit = -1;
        ui64 HardLimit = -1;
        ui64 AllocationThreshold = -1;
        // REFRESH-529
        ui64 SoftReclaimDivisor = 1000000;
        ui64 AngryReclaimDivisor = 1000000;

        void InitByDirectives(const TYandexConfig::Directives& directives);

        TString ToString() const;

    };

    struct TSysEnv {
        TMap<TString, TThrottle::TOptions> Io;

        TBallocOptions BallocOptions;

        TSysEnv();

        void InitOneIoOption(const TString& name, const TYandexConfig::Directives& directives);

        void Init(const TYandexConfig::TSectionsMap& sysEnvSections);

        TString ToString() const;
    };

}
