LIBRARY()

OWNER(
    g:saas
)

WERROR()

SRCS(
    common_indexers_config.cpp
    config.cpp
    get_value.cpp
    grouping_config.cpp
    indexer_config.cpp
    logger_config.cpp
    merger_config.cpp
    monitor_config.cpp
    realm_config.cpp
    repair_config.cpp
    search_server_options.cpp
    searcher_config.cpp
    shards_config.cpp
    sys_env.cpp
    zone_extractor_config.cpp
)

GENERATE_ENUM_SERIALIZATION(config.h)
GENERATE_ENUM_SERIALIZATION(merger_config.h)
GENERATE_ENUM_SERIALIZATION(searcher_config.h)

PEERDIR(
    contrib/libs/protobuf
    kernel/multipart_archive/config
    kernel/qtree/request
    library/cpp/digest/md5
    library/cpp/html/face
    library/cpp/html/zoneconf
    library/cpp/http/server
    library/cpp/object_factory
    library/cpp/protobuf/protofile
    library/cpp/streams/special
    library/cpp/yconf
    robot/library/oxygen/indexer/processor/protos
    saas/library/daemon_base/config
    saas/library/daemon_base/daemon
    saas/library/daemon_base/module
    saas/library/sharding
    saas/rtyserver/factors
    saas/rtyserver/logging
    saas/rtyserver/pruning_config
    saas/rtyserver/synchronizer/library/config
    saas/services/abstract
    search/config
    search/config/preprocessor
    search/grouping
    ysite/parser/xml
)


END()
