#include "zone_extractor_config.h"
#include <util/string/vector.h>

TZoneExtractorConfigItem::TZoneExtractorConfigItem(const TString& name, const char* str)
    : Name(name)
    , StripTags(true)
    , Strip(false)
    , JoinSpans(false)
    , JoinParagraphs(false)
{
    TVector<TString> split = SplitString(str, "," , 2);
    PropName = split.size() > 0 ? split[0] : TString();
    if (split.size() > 1) {
        StripTags = split[1].find("NO_STRIP_TAGS") == TString::npos;
        Strip = split[1].find("STRIP_NEWLINES") != TString::npos;
        JoinSpans = split[1].find("JOIN_SPANS") != TString::npos;
        JoinParagraphs = split[1].find("JOIN_PARAGRAPHS") != TString::npos;
    }
}

void TZoneExtractorConfig::Parse(const TYandexConfig::Directives& directives) {
    if (!directives)
        return;
    for (const auto& i : directives) {
        TString zone(i.first);
        zone.to_lower();
        insert(std::make_pair(zone, TZoneExtractorConfigItem(zone, i.second)));
    }
}

TString TZoneExtractorConfig::ToString(const char* sectionName) const {
    TStringStream ss;
    ss << "<" << sectionName << ">" << Endl;
    for (const auto& i : *this) {
        ss << i.first << " : " << i.second.PropName;
        if (!i.second.StripTags)
            ss << ", NO_STRIP_TAGS";
        if (i.second.JoinSpans)
            ss << ", JOIN_SPANS";
        if (i.second.JoinParagraphs)
            ss << ", JOIN_PARAGRAPHS";
        ss << Endl;
    }
    ss << "</" << sectionName << ">" << Endl;
    return ss.Str();
}
