#pragma once

#include <util/generic/string.h>
#include <util/generic/hash.h>
#include <library/cpp/yconf/conf.h>

struct TZoneExtractorConfigItem {
    TZoneExtractorConfigItem(const TString& name, const char* str);

    TString Name;
    TString PropName;
    bool StripTags;
    bool Strip;
    bool JoinSpans;
    bool JoinParagraphs;
};

class TZoneExtractorConfig : public THashMap<TString, TZoneExtractorConfigItem> {
public:
    void Parse(const TYandexConfig::Directives& directives);
    TString ToString(const char* sectionName) const;
};
