#pragma once

#include <saas/library/daemon_base/daemon/controller.h>
#include <saas/library/daemon_base/daemon/daemon.h>
#include "rtyserver.h"

class TRTYController : public TController {
public:
    TRTYController(
        TServerConfigConstructorParams& params,
        const TController::IServerDescriptor& sd,
        bool setReportFactory = true
    );
    void SaveConfig();

    class TRTYClient: public TClient {
    public:
        TRTYClient(TController& owner);
        virtual void ProcessServerStatus();
        virtual void ProcessSuperMind(IOutputStream& out) const;
    };

    TClientRequest* CreateClient() override {
        return new TRTYClient(*this);
    }

    void CheckConfig(IServerConfig& config, bool onStart) const override;
    bool Process(IMessage* message) override;

private:
    void StopServer(ui32 rigidStopLevel, const TCgiParameters* cgiParams) override {
        Server->Stop(rigidStopLevel, cgiParams);
    }
};
