#pragma once

#include <saas/library/daemon_base/controller_actions/async_controller_action.h>

#define CLEAR_INDEX_ACTION_NAME "CLEAR_INDEX"

namespace NDaemonController {

    class TClearIndexAction : public TControllerAsyncAction {
    protected:

        virtual NJson::TJsonValue DoSerializeToJson() const override;
        virtual void DoDeserializeFromJson(const NJson::TJsonValue& json) override;

        virtual TString ActionName() const override {
            return CLEAR_INDEX_ACTION_NAME;
        }

        static TFactory::TRegistrator<TClearIndexAction> Registrator;

    public:

        TClearIndexAction()
            : TControllerAsyncAction(NDaemonController::apStartAndWait)
        {}

        TClearIndexAction(const TString& waitActionName)
            : TControllerAsyncAction(waitActionName)
        {}

        TClearIndexAction(TAsyncPolicy asyncPolicy)
            : TControllerAsyncAction(asyncPolicy)
        {}

        virtual TString DoBuildCommandStart() const override {
            return "command=clear_index&async=yes";
        }

    };
}
