#include "shards_action.h"

namespace NDaemonController {

    NJson::TJsonValue TShardsAction::DoSerializeToJson() const {
        NJson::TJsonValue result(NJson::JSON_MAP);
        if (!WaitActionName) {
            result.InsertValue("shard_min", ShardMin);
            result.InsertValue("shard_max", ShardMax);
            result.InsertValue("sharding", Sharding.ToString());
            result.InsertValue("act_type", (ui32)ActType);
        }
        return result;
    }

    void TShardsAction::DoDeserializeFromJson(const NJson::TJsonValue& json) {
        NJson::TJsonValue::TMapType map;
        CHECK_WITH_LOG(json.GetMap(&map));
        if (!WaitActionName) {
            ShardMin = map["shard_min"].GetIntegerRobust();
            ShardMax = map["shard_max"].GetIntegerRobust();
            Sharding = NSaas::TShardsDispatcher::TContext::FromString(map["sharding"].GetStringRobust());
            ActType = (ActionType)map["act_type"].GetIntegerRobust();
        }
    }

    TShardsAction::TFactory::TRegistrator<TShardsAction> TShardsAction::Registrator(SHARDS_ACTION_NAME);
}
