#pragma once

#include <saas/library/daemon_base/controller_actions/async_controller_action.h>
#include <saas/library/sharding/sharding.h>

#define SHARDS_ACTION_NAME "SYNC_SHARDS"

namespace NDaemonController {

    class TShardsAction : public TControllerAsyncAction {
    public:
        enum ActionType {satRemove, satCheck};

    private:
        ui32 ShardMin;
        ui32 ShardMax;
        NSaas::TShardsDispatcher::TContext Sharding;
        ActionType ActType;
    protected:

        virtual NJson::TJsonValue DoSerializeToJson() const;
        virtual void DoDeserializeFromJson(const NJson::TJsonValue& json);

        virtual TString ActionName() const {
            return SHARDS_ACTION_NAME;
        }

        static TFactory::TRegistrator<TShardsAction> Registrator;

    public:

        TShardsAction()
            : TControllerAsyncAction(NDaemonController::apStartAndWait)
            , Sharding(NSaas::UrlHash)
        {}

        TShardsAction(const TString& waitActionName)
            : TControllerAsyncAction(waitActionName)
            , Sharding(NSaas::UrlHash)
        {
        }

        TShardsAction(ui32 shardMin, ui32 shardMax, const NSaas::TShardsDispatcher::TContext& sharding, ActionType actionType, TAsyncPolicy asyncPolicy)
            : TControllerAsyncAction(asyncPolicy)
            , Sharding(sharding)
        {
            ShardMin = shardMin;
            ShardMax = shardMax;
            ActType = actionType;
        }

        virtual TString DoBuildCommandStart() const {
            TString actionStr;
            if (ActType == satCheck)
                actionStr = "check";
            else if (ActType == satRemove)
                actionStr = "remove";
            else
                FAIL_LOG("Incorrect behaviour");
            return "command=synchronizer&async=yes&action=shards&min_shard=" + ToString(ShardMin) + "&max_shard=" + ToString(ShardMax) + "&sharding_type=" + Sharding.ToString() + "&act_shards=" + actionStr;
        }

    };
}
