#include "rtyserver_diag.h"

TRTYRecoveryStage TRTYServerDiagState::GetRecoveryStage(bool repairing, bool isSearching) const {
    if (isSearching)
        return TRTYRecoveryStage::None;

    if (repairing)
        return !WasSearching ? TRTYRecoveryStage::Repair : TRTYRecoveryStage::None;

    if (IsSynchronizing)
        return TRTYRecoveryStage::Sync;

    if (!WasSearching && WasSynchronizing)
        return TRTYRecoveryStage::PostSync;

    //Note: PostSync turns to None at the first EnableSearch command. In other words, to differentiate between PostSync and None
    //for the banned replicas, we expect that there is an explicit EnableSearch command after the Sync is completed

    return TRTYRecoveryStage::None;
}

bool TRTYServerDiagState::Process(IMessage* message) {
    auto* msg = message->As<TMessageNotifyDiagEvent>();
    if (msg) {
        const TString &event = msg->GetType();

        if (event == "streamSyncRequired")
            OnSync();
        else if (event == "streamSyncCompleted")
            OnSyncCompleted();
        else
            msg = nullptr;
    }

    return msg;
}

TString TRTYServerDiagState::Name() const {
    return "TRTYServerDiagState";
}
