#pragma once

#include <saas/rtyserver/common/common_messages.h>

class TRTYServerDiagState : public IMessageProcessor {
public:
    TRTYServerDiagState() {
        RegisterGlobalMessageProcessor(this);
    }

    ~TRTYServerDiagState() {
        UnregisterGlobalMessageProcessor(this);
    }

    TRTYRecoveryStage GetRecoveryStage(bool repairing, bool isSearching) const;

    // IMessageProcessor
    virtual bool Process(IMessage* message) override;
    virtual TString Name() const override;

protected:
    bool WasSynchronizing = false;
    bool IsSynchronizing = false;
    bool WasSearching = false;

public:
    inline bool GetWasSearching() const {
        return WasSearching;
    }

public:
    inline void OnSync() {
        WasSynchronizing = true;
        IsSynchronizing = true;
    }
    inline void OnSyncCompleted() {
        IsSynchronizing = false;
    }
    inline void OnEnableSearchCommand() {
        WasSearching = true;
    }
};
