#pragma once

#include <saas/library/daemon_base/metrics/metrics.h>
#include <library/cpp/mediator/messenger.h>

#include <util/generic/vector.h>
#include <util/generic/string.h>

class TStartupJournal: public IMessageProcessor {
private:
    struct TStartEvent {
        ui32 Time = 0;
        bool AfterCrash = false;
    };

public:
    struct TStopEvent {
        ui32 Time = 0;
        i32 Code = 0;
        TString Message;
    };

private:
    TVector<TStartEvent> StartupLog;
    TStopEvent ShutdownInfo;
    static const ui32 MAX_AGE_TO_KEEP = 60 * 60 * 24 * 365;
    static const ui32 MAX_REPORT_LINES = 100;
    TString ShutdownFile;
    TAutoGlobal<TOrangeMetric> CrashMetric;

public:
    TStartupJournal(const TString& folder, const TString& suffix = "");
    ~TStartupJournal();

    void ServerExits();
    ui32 GetCrashCount(ui32 maxAge = 60 * 60 * 3) const;
    bool IsAfterCrash() const;
    const TStopEvent& GetShutdownInfo() const;
    TString Report();

    virtual TString Name() const override;
    virtual bool Process(IMessage* message) override;
};
