#include "config_wd.h"
#include <util/string/cast.h>


NFusion::TMinRankCondition::TMinRankCondition(const TString& value) {
    if (value == "paused")
        MinRank = PausedValue;
    else if (!value)
        MinRank = DisabledValue;
    else
        MinRank = FromString<double>(value);
}

TString NFusion::TMinRankCondition::ToString() const {
    if (MinRank == PausedValue)
        return "paused";
    else if (MinRank == DisabledValue)
        return TString();
    else
        return ::ToString(MinRank);
}
