#pragma once

#include <util/generic/string.h>
#include <util/datetime/base.h>

// Misc. data formats and types
namespace NFusion {
    //
    // Value type for the condition on minimal rank
    //
    struct TMinRankCondition {
    public:
        inline TMinRankCondition(double vl = DisabledValue)
                : MinRank(vl)
        {}

        TMinRankCondition(const TString& str);

        TString ToString() const;

        inline double GetValue() const {
            return MinRank;
        }
        inline bool IsPaused() const {
            return MinRank == PausedValue;
        }
        inline bool IsAllowedRank(double rank) const {
            return MinRank == DisabledValue || rank >= MinRank;
        }
        inline bool operator==(const TMinRankCondition& other) const {
            return MinRank == other.MinRank;
        }
        inline bool operator!=(const TMinRankCondition& other) const {
            return !(*this == other);
        }

        static constexpr double DisabledValue = std::numeric_limits<double>::lowest();
        static constexpr double PausedValue = DisabledValue / 2;

    protected:
        double MinRank;
    };

    //
    // Options that can be set using a watchdog handle (ITS)
    //
    struct TDocfetcherItsOptions {
        TMinRankCondition MinRank;
        TInstant MinTimestamp;
        bool DropPosition = false;
    };
}
