#pragma once

#include <saas/library/zk/zk.h>
#include <saas/rtyserver/docfetcher/library/types.h>
#include <saas/util/network/http_request.h>


namespace NFusion {
    namespace NDatacenterChecker {
        struct TSuccessCheck {
            TMap<TString, bool> DcToFailed;
            TSuccessCheck(TMap<TString, bool> dcToFailed) : DcToFailed(dcToFailed) { }
        };

        struct TErrorCheck {
            TString ErrorMessage;
            TErrorCheck(TString errorMessage) : ErrorMessage(errorMessage) { }
        };

        using TCheckResult = std::variant<TSuccessCheck, TErrorCheck>;

        class IDataSource {
        public:
            virtual TCheckResult RunCheck() = 0;
            virtual ~IDataSource() = default;
        };

        class TExternalAPIDataSource : public IDataSource {
        private:
            TExternalAPIDataSourceConfig Config;
            NUtil::THttpRequest Request;

        public:
            TExternalAPIDataSource(const TExternalAPIDataSourceConfig& config);
            TMap<TString, bool> ParseReplyContent(NUtil::THttpReply& reply);
            TCheckResult RunCheck() override;
        };

        class TZookeeperDataSource : public IDataSource, public NSaas::TZKClient {
        private:
            TZookeeperDataSourceConfig Config;

        public:
            TZookeeperDataSource(const TZookeeperDataSourceConfig& config);
            TMap<TString, bool> ParseZKData(const TString& data);
            TCheckResult RunCheck() override;
        };
    }
}
