#pragma once

#include "types.h"

#include <saas/library/daemon_base/module/module.h>

#include <util/generic/maybe.h>
#include <util/generic/vector.h>

namespace NFusion {

constexpr TStringBuf DocfetcherModuleName = "DOCFETCHER";

class TDocFetcherConfig: public TPluginConfig<IDaemonModuleConfig> {
protected:
    virtual void DoInit(const TYandexConfig::Section& moduleSection);
    virtual bool DoCheck() const;
    virtual void DoToString(IOutputStream& so) const;

    EStreamType GetStreamType(const TYandexConfig::Directives& directives) const;
    void ParseStreamConfig(const TYandexConfig::Section& section, TStreamConfig& stream) const;
    void ParseStreamConfig(const TYandexConfig::Section& section, TMapReduceStreamConfig& stream) const;
    void ParseStreamConfig(const TYandexConfig::Section& section, TPersQueueStreamConfig& stream) const;
    void ParseStreamConfig(const TYandexConfig::Section& section, TSnapshotStreamConfig& stream) const;
    void ParseSyncConfig(const TYandexConfig::Section& section, TSyncOptions& stream) const;
    void ParseDocStreamConfig(const TYandexConfig::Directives& directives, TDocStreamConfig& stream) const;
    void ParseCommonStreamConfig(const TYandexConfig::Directives& directives, TBaseStreamConfig& stream) const;

    void PrintStreamConfig(const TStreamConfig& stream, IOutputStream& so) const;
    void PrintStreamConfig(const TMapReduceStreamConfig& stream, IOutputStream& so) const;
    void PrintStreamConfig(const TPersQueueStreamConfig& stream, IOutputStream& so) const;
    void PrintStreamConfig(const TSnapshotStreamConfig& stream, IOutputStream& so) const;
    void PrintSyncConfig(const TSyncOptions& stream, IOutputStream& so) const;
    void PrintDocStreamConfig(const TDocStreamConfig& stream, IOutputStream& so) const;
    void PrintCommonStreamConfig(const TBaseStreamConfig& stream, IOutputStream& so) const;

    void ParseDatacenterCheckerConfig(const TYandexConfig::Section& section, TDatacenterCheckerConfig& checker) const;
    void PrintDatacenterCheckerConfig(const TDatacenterCheckerConfig& checker, IOutputStream& so) const;

    TConsistentClientReplicas ParseClientReplicas(const TYandexConfig::TSectionsMap& sections, const TStreamConfig& stream) const;
    void PrintClientReplicas(const TConsistentClientReplicas& replicas, IOutputStream& so) const;

    TPersQueueStreamConfig::TReplicaIdsList ParseReplicaIds(const TYandexConfig::TSectionsMap& sections) const;
    void PrintReplicaIds(const TPersQueueStreamConfig::TReplicaIdsList& replicaIdsList, IOutputStream& so) const;

    TConsistentClientOptions ParseClientOptions(const TString& value) const;
    TString PrintClientOptions(const TConsistentClientOptions& value) const;

    NRealTime::TDistributors PreresolveAndFilter(const NRealTime::TDistributors& distributors) const;

public:
    TMaybe<TDatacenterCheckerConfig> PQDatacenterChecker;
    TVector<TStreamConfig> Streams;
    TVector<TStreamConfig> DistributorStreams;
    TVector<TMapReduceStreamConfig> MapReduceStreams;
    TVector<TPersQueueStreamConfig> PersQueueStreams;
    TMaybe<TSnapshotStreamConfig> SnapshotStream;

    bool Enabled = false; // RTYSERVER use-case: enables DOCFETCHER module but does not want it to run
    TString LogFile = "docfetcher.log";
    TString SysLogFile;
    TString WatchdogOptionsFile;
    i32 SearchOpenDocAgeSec = -1;  // Only in the scenario when fusion was started with empty index, do not open search port until incoming docs are younger than this age
    bool EnableSearchOnStart = false; // Useful with "Searcher.AutoStartServer: false"
};
}
