#pragma once

#include <yweb/realtime/distributor/client/options/options.h>

namespace NFusion {
    class ISignatureProvider;

    struct TConsistentClientOptions: public NRealTime::TDistributorClientOptions {
        TString ClientId;
        TString MetricsPrefix = "ConsistentClient";
        TDuration UpdateInterval = TDuration::MilliSeconds(100);
        TDuration DynamicSwitchInterval = TDuration::Minutes(1);
        const ISignatureProvider* SignatureProvider = nullptr;
        ui32  Capacity = 10000;
        ui32  MaxPrimaryReplicas = Max<ui32>();
        ui32  MaxPreloadCount = 10000;
        ui32  MaxPrefetchCount = 1000;
        ui32  MaxFetchFails = 3;
        ui32  MaxResponseChunks = 0;
        float PreloadFactor = 0.5f;
        float PrefetchFactor = 0.3f;
        float AgeSwitchFactor = 0.1f;
        float FailRateSwitchFactor = 0.1f;
        bool  DynamicSwitch = false;
    };

    struct TConsistentClientReplica: public NRealTime::TDistributors {
        ui32 StartAge = 0;
        ui32 Priority = 0;
        ui16 Id = 0;
    };
    using TConsistentClientReplicas = TVector<TConsistentClientReplica>;
}
