#pragma once

#include "docstream.h"
#include <saas/rtyserver/docfetcher/config_wd.h>

namespace NFusion {
    struct TPersQueueStreamConfig;

    class IPersQueueReader;
    class TDatacenterChecker;
    class TPersQueueStream : public TDocStream, SignalsHolder<TPersQueueStreamSignals> {
        using TBase = TDocStream;

    public:
        TPersQueueStream(
            const TDocFetcherModule& owner,
            const TPersQueueStreamConfig& config,
            const TRTYServerConfig& globalConfig,
            TAtomicSharedPtr<TDatacenterChecker> datacenterChecker,
            TLog& log,
            TLog& syslog
        );
        ~TPersQueueStream();

        void OnWatchdogOption(const TString& key, const TString& value) override;
        void SubscribeToWatchdog(IWatchdogOptions& w) override;

    protected: // TDocStream
        virtual void OnDocStreamStart() override;
        virtual void OnDocStreamStop() override;
        virtual TDuration GetDelay() const override;
        virtual bool IsExhausted() const override;
        virtual NFusion::TActionPtr GetDoc(TMap<TString, TString>& propsToLog, bool& skipSleepOnError) override;
        virtual void ReportStatus(NJson::TJsonValue& status) override;

        TCommonDocStreamSignals* SignalsBase() const override {
            return SignalsHolder<TPersQueueStreamSignals>::Signals();
        }

    protected: // IMessageProcessor
        virtual bool Process(IMessage* message) override;

    protected:
        void SetTimestamp(TInstant ts, bool incrementOnly);
        void SetMinTimestamp(TInstant ts);
    private:
        TDuration GetDelay(const NRTYServer::TTimestampSnapshot& snapshot) const;
        void ReportIncorrectDoc(const TString& expl, TActionPtr action = nullptr);

    private:
        const TPersQueueStreamConfig& Config;
        TDocfetcherItsOptions ItsOptions;
        THolder<IPersQueueReader> Client;
        TInstant LastReceiveTimestamp;

        TWatchdogSubscription Watchdog;
    };
}

