#pragma once
#include "factors_abstract.h"
#include "factor.h"

template <class TFactorsStorage>
class TSimpleStaticFactorsDescriptionImpl: public IRTYStaticFactors {
protected:
    const TFactorsStorage& FactorsList;
public:

    explicit TSimpleStaticFactorsDescriptionImpl(const TFactorsStorage& factorsList)
        : FactorsList(factorsList)
    {

    };

    virtual ui32 GetStaticFactorsCount() const {
        return FactorsList.size();
    }

    virtual const NRTYFactors::TSimpleFactorDescription& GetFactor(ui32 index) const {
        VERIFY_WITH_LOG(FactorsList.size() > index, "%lu > %u", FactorsList.size(), index);
        return FactorsList[index];
    }
};

typedef TSimpleStaticFactorsDescriptionImpl<NRTYFactors::TFactorsList> TSimpleStaticFactorsDescription;
typedef TSimpleStaticFactorsDescriptionImpl<NRTYFactors::TSimpleFactorsList> TBaseStaticFactorsDescription;
