#pragma once

#include "factors_blocks.h"
#include "factors_plugin.h"

namespace NRTYFactors {
    class TFactorSet;
}

namespace NRTYFactors {
    struct TTimeFactorData {
        i32 BaseIndex;
        i32 DeltaIndex;
        i32 InvDeltaIndex;
        TTimeFactorData()
            : BaseIndex(-1)
            , DeltaIndex(-1)
            , InvDeltaIndex(-1)
        {

        }
        TTimeFactorData(i32 baseIndex, bool inv, i32 index)
            : BaseIndex(baseIndex)
            , DeltaIndex(-1)
            , InvDeltaIndex(-1)
        {
            if (inv)
                InvDeltaIndex = index;
            else
                DeltaIndex = index;
        }
    };

    struct TRTYFactorMask {
        i32 IndexLiveTime = -1;
        i32 IndexInvLiveTime = -1;
        i32 IndexFreshnessDay = -1;
        i32 IndexFreshnessWeek = -1;
        i32 IndexFreshnessMonth = -1;
        bool StaticFactors = false;
        bool DynamicFactors = false;
        bool UsesFactorAnnWithoutTm = false; // need WEB_PRODUCTION factors that are calculated by FactorAnnCalcer without a text machine
        bool UsesWebTextMachine = false; // need WEB_PRODUCTION factors that are calculated by the "ordinary" text machine
        bool ZoneFactors = false;
        TVector<TTimeFactorData> RefineFactors;
        TVector<TTimeFactorData> TimeFactors;
        TVector<TDpFactorData> PluginFactors;
        TRTYBlocksFactorsInfo CSFactorsInfo;
        TRTYBlocksFactorsInfo QSFactorsInfo;
    };
};
