#pragma once

#include <util/generic/fwd.h>
#include <util/generic/string.h>

namespace NRTYFactors {
    /// TDpFactorData: rty_dynamic_factor implemented through a plugin
    struct TDpFactorData {
        TString SourceFactor;
        i32 BaseIndex = -1;

        TDpFactorData() = default;

        TDpFactorData(const TString& sourceFactor, i32 baseIndex)
            : SourceFactor(sourceFactor)
            , BaseIndex(baseIndex)
        {
        }
    };
}
