#pragma once

namespace NRTYFactors {
    struct TFactorPoliteness {
    public:
        bool IsStrict = false;

    public:
        TFactorPoliteness() = default;

        TFactorPoliteness(bool strict)
            : IsStrict(strict)
        {
        }

        inline bool AllowMissingExtraFactors() const {
            return !IsStrict;
        }

        inline bool AllowMissingUserFactors() const {
            return !IsStrict;
        }

        inline bool AllowDoubleCalc() const {
            return !IsStrict;
        }

    public:
        static TFactorPoliteness Strict() {
            return TFactorPoliteness(true);
        }
    };
}
