#include "fictive_factors_info.h"

#include <util/generic/ylimits.h>

namespace NRTYFactors {

    TFictiveFactorsInfo::TFictiveFactorsInfo()
        : FictiveFactorsGlobalIndex(EFictiveFactors::COUNT, Max<ui32>())
    {
    }

    bool TFictiveFactorsInfo::IsFictiveFactor(ui32 factorIndex) const {
        return std::find(FictiveFactorsGlobalIndex.begin(),
                        FictiveFactorsGlobalIndex.end(), factorIndex) != FictiveFactorsGlobalIndex.end();
    }
}
