#include "user_values_storage.h"

#include <kernel/externalrelev/relev.h>

namespace NRTYFactors {

    const IStoredType* IStoreValueCalcer::Get(TCalcFactorsContext& ctx, ui32 typeId, bool enableCacheInvalidation) {
        if (enableCacheInvalidation && DocId != ctx.DocId && DependsOnDoc()) {
            Clear();
        }
        DocId = ctx.DocId;
        auto result = DoGet(ctx, typeId);
        UpdateDependsOnDoc();
        return result;
    }

}
