#pragma once

#include "final_index_processor.h"

#include <util/thread/pool.h>

class TFinalIndexNormalizer: public TFinalIndexProcessor, public IObjectInQueue {
public:
    static TFinalIndexNormalizer* Create(const TPathName& indexDir, const TRTYServerConfig& config, NRTYServer::EExecutionContext execCtx);
    static bool BuildServiceFiles(const TPathName& indexDir, const TRTYServerConfig& config, NRTYServer::EExecutionContext execCtx=NRTYServer::EExecutionContext::Normalize);

    ~TFinalIndexNormalizer();
    //IObjectInQueue
    virtual void Process(void* ThreadSpecificResource);
    //IIndexOwner
    virtual NGroupingAttrs::TDocsAttrs* GetGroupsAttrs() const;
    virtual const IKeysAndPositions* GetYndex() const;

protected:
    TFinalIndexNormalizer(const TPathName& indexDir, const TRTYServerConfig& config, NRTYServer::EExecutionContext execCtx);
    virtual void LinkIndexData();
    virtual void UnlinkIndexData();

private:
    bool CheckAndRepair();
    void CheckOrFail();
private:
    THolder<IKeysAndPositions> Yndex;
    mutable THolder<NGroupingAttrs::TDocsAttrs> DocsAttrs;
};
