#pragma once

#include <saas/rtyserver/components/generator/builders_storage.h>
#include <saas/rtyserver/common/common_rty.h>
#include <saas/rtyserver/model/component.h>
#include <saas/rtyserver/model/index.h>

class TFinalIndexProcessor : public NRTYServer::IIndexOwner {
    friend class TDocIdIterator;
public:
    virtual ~TFinalIndexProcessor();

protected:
    TFinalIndexProcessor(const TPathName& indexDir, const TRTYServerConfig& config, bool useGlobalFileMapping, NRTYServer::EExecutionContext execCtx);

    ui32 GetDocumentsCountImpl(bool keyWithDeleted = true) const;
    ui32 GetSearchableDocumentsCountImpl() const;
    ui32 GetDeletedDocumentsCount() const;
    virtual void Initialize();
    virtual void LinkIndexData() override;
    virtual void UnlinkIndexData() override;

    bool IsLinked() const {
        return CounterLinks;
    }

    virtual NRTYServer::ERealm GetRealm() const override;
    virtual TString GetRealmName() const override;
    virtual const IUrlIdInfo* GetUrlIdInfo() const override;
    virtual bool DocumentIsRemoved(const ui32 docid) const override;

    static IIndexController::EIndexType GetIndexType(const TPathName& indexDir);

protected:
    const TPathName IndexDir;
    const TRTYServerConfig& Config;
    const NRTYServer::TRealmConfig& RealmConfig;
    const ui32 Shard;
    IIndexController::EIndexType IndexType;
    TRTYIndexManagersStorage Managers;
    const TBaseGeneratorManager* IndexManager;
    const IDDKManager* DDKManager;
    const IUrlToDocIdManager* UrlToDocIdManager;
    NRTYServer::EExecutionContext ExecutionContext;

private:
    int CounterLinks;
};
