#pragma once

#include "index_storage.h"


class TIndexConsumeTransaction: public IIndexConsumeTransaction {
    static const TString StartConsumeMetaPrefix;
public:
    static void GetIncompletedTransactionIndicies(const TString& indexDir, TVector<TString>& transactionIndicies, TVector<TString>& metaFiles);
    static void CreateTransactionFile(const TString& indexDir, const TVector<TString>& indicies); // for unit tests

    TIndexConsumeTransaction(TIndexStorage::TPtr storage, const TString& indexRootDirectory);
    ~TIndexConsumeTransaction();

    ///
    /// IIndexConsumeTransaction
    ///
    TIndexControllerPtr ConsumeIndex(const TString& indexDirName, NRTYServer::EConsumeMode mode) override;
    void Commit() override;
    void Revert() override;

private:
    void FinishTransaction();
    TString ListIndicies() const;

    static void WriteLine(TFile& f, const TString& line);

private:
    TIndexStorage::TPtr IndexStorage;
    TString IndexRootDirectory;
    TFile StartConsumeMeta;

    TVector<TString> AddedIndices;
    bool Finished {false};
};
