#pragma once

#include "parsed_document.h"
#include "abstract_model.h"

class TComponentParser: public NRTYServer::IComponentParser, public TParsedDocument::TProtectedFieldsSetter {
public:
    typedef NRTYServer::IComponentParserContext TParsingContext;
public:
    virtual ~TComponentParser() = default;
    virtual void Parse(NRTYServer::IComponentParserContext& context) const;
};

class TDocumentParser: public TParsedDocument::TProtectedFieldsSetter {
public:
    void Parse(TParsedDocument& result, const NRTYServer::TMessage::TDocument& document, NRTYServer::TMessage::TMessageType command, const NRTYServer::TDocParseContext& docParseContext) const;
    void CreateAndRegisterParser(const NRTYServer::IIndexComponent& component);
private:
    typedef THashMap<TString, NRTYServer::IComponentParser::TPtr> TComponentParsers;
    TComponentParsers Parsers;
};
