#include "file_index_modify_guard.h"
#include <util/generic/singleton.h>
#include <util/string/cast.h>

ITransaction* TFileIndexModifyGuard::Get() {
    return Singleton<TFileIndexModifyGuard>()->Transactions.Get();
}

void TFileIndexModifyGuard::Reset(ui32 shardsNumber) {
    TTransactions ptr{new ITransaction[shardsNumber]};
    for (ui32 i = 0; i < shardsNumber; ++i) {
        ptr[i].SetMessage("shard " + ToString(i) + " modification");
    }
    Singleton<TFileIndexModifyGuard>()->Transactions.Reset(ptr.Release());
}
