#pragma once

#include <saas/util/transaction.h>
#include <util/generic/ptr.h>
#include <saas/util/named_lock.h>

class TIndexConstructionLocks {
public:
    static NNamedLock::TNamedLockPtr Start(const TString& dirName) {
        return NNamedLock::TryAcquireLock(dirName);
    }
};

class TFileIndexModifyGuard {
public:
    static ITransaction* Get();
    static void Reset(ui32 shardsNumber);
private:
    typedef TArrayHolder<ITransaction> TTransactions;
    TTransactions Transactions;
};
