#pragma once

#include <util/generic/string.h>
#include <util/folder/path.h>

constexpr TStringBuf DIRPREFIX_INDEX = "index_";
constexpr TStringBuf DIRPREFIX_MEM = "memory_index_";
constexpr TStringBuf DIRPREFIX_TEMP = "temp__";
constexpr TStringBuf DIRPREFIX_PREP = "prep_index_";

namespace NRTYServer {

    bool HasIndexNamePrefix(const TStringBuf& indexBasename, const TStringBuf& kindPrefix) noexcept;

    inline bool HasIndexDirPrefix(const TFsPath& indexDir, const TStringBuf& kindPrefix) noexcept {
        return HasIndexNamePrefix(indexDir.Basename(), kindPrefix);
    }

    bool IsIndexDirOnTmpfs(const TFsPath& indexDir) noexcept;
}

