#pragma once
#include <util/generic/string.h>
#include <util/folder/filelist.h>
#include <library/cpp/digest/md5/md5.h>
#include <util/generic/hash.h>
#include <util/folder/dirut.h>
#include <util/system/fstat.h>
#include "abstract_model.h"
#include <saas/protos/rtyservice.pb.h>

class TIndexHashChecker {
private:
    THashMap<TString, TString> CurrentHashes;
    THashMap<TString, NRTYService::TFileCheck> SavedHashes;
    TFsPath DirPath;
    const TRTYServerConfig& Config;
    bool SaveHashesFlag;
private:
    TString CalcFileHash(const NRTYServer::IIndexComponent& component, const TString& fileName);
    TString BuildHash(const NRTYServer::IIndexComponent& component, bool afterRepair);
    const NRTYService::TFileCheck* GetCheckInfo(const TString& checkName);

public:
    TIndexHashChecker(const TRTYServerConfig& config, const TString& filesPath, bool saveHashes = true);
    ~TIndexHashChecker();

    void SaveCheckData(const NRTYServer::IIndexComponent& component, bool afterRepair);
    bool NeedInCheck(const NRTYServer::IIndexComponent& component);
};
