#pragma once

#include "abstract_model.h"

#include <saas/library/histogram/histogram.h>
#include <saas/rtyserver/common/common_rty.h>
#include <saas/rtyserver/config/fwd.h>
#include <saas/rtyserver/common/stream_data.h>

#include <kernel/indexer/baseproc/baseconf.h>
#include <kernel/tarc/dirconf/dirconf.h>

class TIndexerCore: public IIndexer {
protected:
    const NRTYServer::TIndexerConfig& Config;
    const ui32 Shard;
    const ui32 Capacity;
    TAtomic DocId;

    TBaseConfig BaseConfig;
    TDirConf DirConfig;

    mutable NRTYServer::TIndexTimestamp Timestamp;
    mutable NRTYServer::TIndexPositions Positions;

protected:
    NRTYServer::TBuilderConstructionContext GetBuildersContructionContext();
    void UpdateIndexerTimestamp(const TParsedDocument& document);
    void UpdateIndexerPositions(const TParsedDocument& document);

public:
    TPathName Dir;
    TPathName TempDir;

public:
    TIndexerCore(const TString& indexDirName, const TString& tempDirName, const TString& rootDir,
        const NRTYServer::TIndexerConfig& config, ui32 shard);

    const TString& IndexerType() const;

    virtual const TPathName& Directory() const override {
        return Dir;
    }
    virtual const NRTYServer::THistograms& GetHistograms() const override {
        return Default<NRTYServer::THistograms>();
    }
    virtual NRTYServer::TIndexTimestamp& GetTimestamp() const override {
        return Timestamp;
    }
    virtual NRTYServer::TIndexPositions& GetPositions() const override {
        return Positions;
    }

    bool IsFull() const override {
        return DocId >= Capacity;
    }

    bool IsEmpty() const override {
        return DocId == 0;
    }

    virtual TInterval<double> GetPruneInterval() const override {
        return TInterval<double>(0, ::Max<double>());
    }
    virtual ui32 GetDocsCountInInterval(const TInterval<double>& /*interval*/) const override {
        return 0;
    }
    virtual ui32 GetShard() const override {
        return Shard;
    }
    virtual ui32 GetState() const override {
        return 0;
    }
};
