#pragma once

#include "guarded_document.h"

#include <library/cpp/mediator/messenger.h>

class TMessageReopenIndexes: public IMessage {
public:
    TMessageReopenIndexes(TQueuedDocument document, const TString& realmName)
        : Document(document)
        , RealmName(realmName)
    {}

    inline TQueuedDocument GetDocument() const {
        return Document;
    }

    inline const TString& GetRealmName() const {
        return RealmName;
    }

private:
    TQueuedDocument Document;
    TString RealmName;
};
