#pragma once

#include "abstract_model.h"

namespace NRTYServer {
    class INormalizer {
    public:
        INormalizer(const TRTYServerConfig& config)
            : Config(config)
        {}
        virtual ~INormalizer() {}
        virtual const char* Name() const = 0;
        virtual bool AllRight(const NRTYServer::TNormalizerContext& context, const THolder<TFileMap>& indexFrq) const = 0;
        virtual void Fix(const NRTYServer::TNormalizerContext& context, const THolder<TFileMap>& indexFrq) const = 0;
    protected:
        const TRTYServerConfig& Config;
    };

    class TNormalizersCollection : public INormalizer {
    private:
        using TNormalizers = TVector<TAtomicSharedPtr<INormalizer>>;
    public:
        TNormalizersCollection(const TRTYServerConfig& config);

        void Register(const TAtomicSharedPtr<INormalizer>& normalizer);
        void Clear();
        void CheckAndFix(const NRTYServer::TNormalizerContext& context, const THolder<TFileMap>& indexFrq) const;
        TString GetNormalizersNames() const;

        // INormalizer
        const char* Name() const override;
        virtual void Fix(const NRTYServer::TNormalizerContext& context, const THolder<TFileMap>& indexFrq) const override;
        virtual bool AllRight(const NRTYServer::TNormalizerContext& context, const THolder<TFileMap>& indexFrq) const override;
    private:
        TNormalizers Normalizers;
    };
}
