#pragma once

#include "parsed_document.h"
#include <kernel/multipart_archive/multipart.h>

namespace NRTYServer {
    class TParsedDocSerializer final : public NRTYArchive::TMultipartArchive::IDocSerializer<TParsedDoc>
        , public NRTYArchive::IDocDeserializer<TParsedDoc>
    {
    public:
        THolder<TParsedDoc> Deserialize(const TBlob& blob) const override;
        TBlob Serialize(const TParsedDoc& doc) const override;
    };

    class TParsedDocumentSerializer final : public NRTYArchive::TMultipartArchive::IDocSerializer<TParsedDocument>
        , public NRTYArchive::IDocDeserializer<TParsedDocument>
    {
    public:
        TParsedDocumentSerializer(const TRTYServerConfig& config, const TDocSerializeContext& serializeCxt, const TDocParseContext& parseCtx, TMessage::TMessageType command);
        THolder<TParsedDocument> Deserialize(const TBlob& blob) const override;
        TBlob Serialize(const TParsedDocument& doc) const override;

    private:
        const TRTYServerConfig& Config;
        TDocSerializeContext SerializeContext;
        TDocParseContext ParseContext;
        TMessage::TMessageType Command;
        TParsedDocSerializer Slave;
    };
}
